# Save to KYT - Brave/Chrome Extension


git remote add origin https://gitlab.com/mywebartist/mwa_kitty_youtube_downloader_brave_extension.git
git push -u origin main



This extension adds a "Save to KYT" button under every YouTube video (Home, Search, Playlists, etc.). Clicking the button sends the video URL to your configured downloader service in the background.

## Features

*   **Universal Button:** Appears under videos on the Home page, Search results, Sidebar, and Playlists.
*   **Background Processing:** Sends the request silently without opening a new tab.
*   **Visual Feedback:** Shows "Processing...", "Saved!" (Checkmark), or "Error" states directly on the button.
*   **Configurable API Key:** Easily update your API key in the extension settings.

## Installation

1.  Download or clone this repository to a folder on your computer.
2.  Open **Brave** or **Chrome** and go to `brave://extensions` or `chrome://extensions`.
3.  Enable **Developer mode** (toggle in the top right corner).
4.  Click **Load unpacked**.
5.  Select the folder containing these files (`mwa_kitty_youtube_downloader_brave_extension`).

## Configuration

1.  Once installed, click the extension icon in the toolbar (you may need to pin it first).
2.  Right-click the icon and select **Options** (or click "Extension Options" from the extensions management page).
3.  Enter your **API Key**.
    *   To get your API key, please visit [https://youtube.mywebartist.eu/](https://youtube.mywebartist.eu/)
4.  Click **Save Settings**.

## Usage

1.  Browse YouTube.
2.  Look for the **Save to KYT** button under any video thumbnail or description.
3.  Click the button.
    *   **Spinner:** The request is being sent.
    *   **Green Checkmark:** The video was successfully sent to the service.
    *   **Red Error:** Something went wrong (check console for details).

## Technical Details

*   **Manifest V3:** Compliant with the latest extension standards.
*   **Permissions:**
    *   `storage`: To save the API key.
    *   `host_permissions`: To access YouTube and the API endpoint.
*   **API Endpoint:** `https://youtube.mywebartist.eu/api/download`
