const fs = require('fs');
const { PNG } = require('pngjs');

const sizes = [16, 48, 128];
const color = { r: 255, g: 100, b: 100, a: 255 }; // Reddish

sizes.forEach(size => {
    const png = new PNG({ width: size, height: size });

    for (let y = 0; y < png.height; y++) {
        for (let x = 0; x < png.width; x++) {
            const idx = (png.width * y + x) << 2;
            png.data[idx] = color.r;
            png.data[idx + 1] = color.g;
            png.data[idx + 2] = color.b;
            png.data[idx + 3] = color.a;
        }
    }

    png.pack().pipe(fs.createWriteStream(`icon${size}.png`))
        .on('finish', () => console.log(`Created icon${size}.png`));
});
