// Default API Key provided in requirements
const DEFAULT_API_KEY = "";

// Restores select box and checkbox state using the preferences
// stored in chrome.storage.
const restoreOptions = async () => {
  const items = await chrome.storage.sync.get({
    apiKey: DEFAULT_API_KEY
  });
  document.getElementById('apiKey').value = items.apiKey;
};

// Saves options to chrome.storage.
const saveOptions = async () => {
  const apiKey = document.getElementById('apiKey').value;
  
  await chrome.storage.sync.set({
    apiKey: apiKey
  });
  
  // Update status to let user know options were saved.
  const status = document.getElementById('status');
  status.textContent = 'Options saved.';
  setTimeout(() => {
    status.textContent = '';
  }, 2000);
};

document.addEventListener('DOMContentLoaded', restoreOptions);
document.getElementById('save').addEventListener('click', saveOptions);
