// Restores input state using the preferences stored in chrome.storage.
const restoreOptions = async () => {
  const items = await chrome.storage.sync.get({
    apiKey: ''
  });
  document.getElementById('apiKey').value = items.apiKey;
};

// Saves options to chrome.storage.
const saveOptions = async () => {
  const apiKeyInput = document.getElementById('apiKey');
  const apiKey = apiKeyInput.value.trim();
  const status = document.getElementById('status');

  if (!apiKey) {
    status.style.color = 'red';
    status.textContent = 'Please enter a valid API Key.';
    return;
  }
  
  await chrome.storage.sync.set({
    apiKey: apiKey
  });
  
  // Update status to let user know options were saved.
  status.style.color = 'green';
  status.textContent = 'Settings saved!';
  setTimeout(() => {
    status.textContent = '';
    window.close(); // Close popup after saving
  }, 1000);
};

document.addEventListener('DOMContentLoaded', restoreOptions);
document.getElementById('save').addEventListener('click', saveOptions);
